/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ruby.internal.debug.ui.breakpoints;

import com.aptana.ruby.internal.debug.ui.breakpoints.BreakpointMessages;
import com.aptana.ruby.internal.debug.ui.breakpoints.LineBreakpointDetailPane;
import com.aptana.ruby.internal.debug.ui.breakpoints.StandardBreakpointDetailPane;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.ui.IDetailPane;
import org.eclipse.debug.ui.IDetailPaneFactory;
import org.eclipse.jface.viewers.IStructuredSelection;

public class BreakpointDetailPaneFactory
implements IDetailPaneFactory {
    private Map<String, String> fNameMap;

    public Set getDetailPaneTypes(IStructuredSelection selection) {
        HashSet<String> set = new HashSet<String>();
        if (selection.size() == 1) {
            IBreakpoint b = (IBreakpoint)selection.getFirstElement();
            try {
                String type = b.getMarker().getType();
                if ("com.aptana.ruby.debug.core.rubyLineBreakpointMarker".equals(type)) {
                    set.add(LineBreakpointDetailPane.DETAIL_PANE_LINE_BREAKPOINT);
                } else {
                    set.add(StandardBreakpointDetailPane.DETAIL_PANE_STANDARD);
                }
            }
            catch (CoreException coreException) {}
        }
        return set;
    }

    public String getDefaultDetailPane(IStructuredSelection selection) {
        if (selection.size() == 1) {
            IBreakpoint b = (IBreakpoint)selection.getFirstElement();
            try {
                String type = b.getMarker().getType();
                if ("com.aptana.ruby.debug.core.rubyLineBreakpointMarker".equals(type)) {
                    return LineBreakpointDetailPane.DETAIL_PANE_LINE_BREAKPOINT;
                }
                return StandardBreakpointDetailPane.DETAIL_PANE_STANDARD;
            }
            catch (CoreException coreException) {}
        }
        return null;
    }

    public IDetailPane createDetailPane(String paneID) {
        if (LineBreakpointDetailPane.DETAIL_PANE_LINE_BREAKPOINT.equals(paneID)) {
            return new LineBreakpointDetailPane();
        }
        if (StandardBreakpointDetailPane.DETAIL_PANE_STANDARD.equals(paneID)) {
            return new StandardBreakpointDetailPane();
        }
        return null;
    }

    public String getDetailPaneName(String paneID) {
        return this.getNameMap().get(paneID);
    }

    public String getDetailPaneDescription(String paneID) {
        return this.getNameMap().get(paneID);
    }

    private Map<String, String> getNameMap() {
        if (this.fNameMap == null) {
            this.fNameMap = new HashMap<String, String>();
            this.fNameMap.put(LineBreakpointDetailPane.DETAIL_PANE_LINE_BREAKPOINT, BreakpointMessages.BreakpointDetailPaneFactory_0);
            this.fNameMap.put(StandardBreakpointDetailPane.DETAIL_PANE_STANDARD, BreakpointMessages.StandardBreakpointDetailPane_0);
        }
        return this.fNameMap;
    }
}

